<?php
session_start();
if (!isset($_SESSION['id'])) {
    header("Location: logout.php");
}

include "db_connect.php";
?>
<!DOCTYPE html>
<html lang="pt-BR" data-bs-theme="auto">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Controle de estoque">
    <meta name="author" content="Jadiel Sousa, OnTop Sistemas">
    <meta name="generator" content="VSCode">
    <title>WContagem - OnTop Sistemas</title>
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/produtos.css" rel="stylesheet">
    <link href="assets/icons/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body class="bg-success bg-gradient">
    <nav class="navbar navbar-expand-md navbar-light bg-light fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php"><i class="bi bi-chevron-left"></i>   WContagem - <?= $_SESSION['nome'] ?></a> 
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav me-auto mb-2 mb-md-0">
                    <a class="nav-item nav-link " href="produtos.php">Produtos</a>
                    <a class="nav-item nav-link active" href="alteracao.php">Alteração</a>
                    <a class="nav-item nav-link " href="historico.php">Histórico</a>
                    <a class="nav-item nav-link " href="logout.php">Sair</a>
                </div>
            </div>
        </div>
    </nav>
    <main class="w-100 form ">
        <div class="container mt-3 mb-3">
            <div class="card">
                <div class="card-header fw-bold"><?php echo $_POST['ardesnot']; ?></div>
                <div class="card-body">
                    <form action="set_estoque.php" method="post">
                        <div class="row">
                            <div class="col-6 my-1">
                                <label for="arcodigo" class="small">CÓDIGO</label>
                                <input type="text" class="form-control" id="arcodigo" name="arcodigo" value="<?php echo $_POST['arcodigo']; ?>" readonly>
                            </div>
                        </div>
                        <div class="row">
                            <!-- <div class="col-12 col-md-5 my-1">
                                <label for="ardesnot" class="small">DESCRIÇÃO</label>
                                <input type="text" class="form-control" id="ardesnot" value="<?php echo $_POST['ardesnot']; ?>" readonly>
                            </div> -->
                            <div class="col-6 col-md-5 my-1">
                                <label for="arnomgru" class="small">GRUPO</label>
                                <input type="text" class="form-control" id="arnomgru" value="<?php echo $_POST['arnomgru']; ?>" readonly>
                            </div>
                            <div class="col-6 my-1">
                                <label for="arnommar" class="small">MARCA</label>
                                <input type="text" class="form-control" id="arnommar" value="<?php echo $_POST['arnommar']; ?>" readonly>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6 my-1">
                                <label for="arrefere" class="small">REFERÊNCIA</label>
                                <input type="text" class="form-control" id="arrefere" value="<?php echo $_POST['arrefere']; ?>" readonly>
                            </div>
                            <div class="col-6 my-1">
                                <label for="arcodbar" class="small">CÓDIGO DE BARRAS</label>
                                <input type="text" class="form-control" id="arcodbar" name="arcodbar" value="<?php echo $_POST['arcodbar']; ?>">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4 my-1">
                                <label for="arunidad" class="small">UND</label>
                                <input type="text" class="form-control" id="arunidad" value="<?php echo $_POST['arunidad']; ?>" readonly>
                            </div>
                            <div class="col-8 my-1">
                                <label for="arlcacao" class="small">LOCAÇÃO</label>
                                <input type="text" class="form-control" id="arlcacao" name="arlcacao" value="<?php echo $_POST['arlcacao']; ?>" oninput="this.value = this.value.toUpperCase()" >
                                <div class="invalid-feedback">Precisa digitar uma locação</div>
                            </div>
                        </div>
			<div class="row">
			    <div class="col my-1 mt-2">
			        <div class="form-check">
				    <input class="form-check-input" type="checkbox" value="1"  id="arfracio" name="arfracio" <?php if ($_POST['arfracio'] == '1') echo 'checked'; ?>>
				    <label class="form-check-label" for="arfracio">PRODUTO FRACIONADO</label>
				</div>
			    </div>
			</div>
                        <div class="row">
                            <div class="col-6 my-1">
                                <label for="qtd_anterior" class="small">QTD ANTERIOR</label>
                                <input type="text" class="form-control" id="qtd_anterior" name="qtd_anterior" value="<?php echo $_POST['arqtd_estok']; ?>" readonly>
                            </div>
                            <div class="col-6 my-1">
                                <label for="qtd_atual" class="small">QTD ATUAL</label>
                                <div class="input-group has-validation">
                                    <input type="number" step="0.001" class="form-control" name="qtd_atual" value="<?php echo $_POST['arqtd_estok']; ?>"required <?= ($_SESSION['estoque'] == 0) ? "readonly" : "" ?> onFocus="this.select()">
                                    <div class="invalid-feedback">Precisa digitar uma quantidade</div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6 my-1">
                                <label for="vlr_anterior" class="small">VLR ANTERIOR</label>
                                <input type="text" class="form-control" id="vlr_anterior" name="vlr_anterior" value="<?php echo $_POST['arvrvend']; ?>" readonly>
                            </div>
                            <div class="col-6 my-1">
                                <label for="vlr_atual" class="small">VLR ATUAL</label>
                                <div class="input-group has-validation">
                                    <input type="number" step="0.01" class="form-control" name="vlr_atual" value="<?php echo $_POST['arvrvend']; ?>" required <?= ($_SESSION['preco'] == 0) ? "readonly" : "" ?> onFocus="this.select()">
                                    <div class="invalid-feedback">Precisa digitar um valor</div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3 ms-1 me-1 mb-3">
                            <div class="col-12 ">
                                <button type="submit" class="btn btn-lg btn-success w-100 "><i class="bi-save"></i> Alterar</button>
                                <input name="sr_recno" value="<?php echo $_POST['sr_recno']; ?>" hidden>
                            </div>
                        </div>
                        <input name="pesquisar" value="1" hidden>
                    </form>
                </div>
            </div>
        </div>
        <div class="container">
            <footer class="fixed-botton pt-3">
                <div class="row">
                    <div class="d-flex justify-content-between border-top text-white">
                        <p><i class="bi-pci-card"></i> <?php echo $_SESSION['mac']; ?></p>
                        <p>&copy; <script>
                                document.write(new Date().getFullYear())
                            </script> <a class="link-light" href="https://ontopsistemas.com.br">OnTop Sistemas</a>.</p>
                    </div>
                </div>

            </footer>
        </div>
    </main>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/sweetalert2.all.js"></script>
    <?php
    if (isset($_SESSION['error'])) {
        if ($_SESSION['error']) {
            $icone = 'error';
        } else {
            $icone = 'success';
        }
    ?><script type="text/javascript">
            Swal.fire('Oops! Algo deu errado!', '<?php echo $_SESSION['msg']; ?>', '<?php echo $icone; ?>');
        </script><?php
                    unset($_SESSION['error']);
                    unset($_SESSION['msg']);
                }
                    ?>
</body>

</html>