<?php
session_start();
if (!isset($_SESSION['id'])) {
    header("Location: logout.php");
}

include "db_connect.php";
?>
<!DOCTYPE html>
<html lang="pt-BR" data-bs-theme="auto">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Controle de estoque">
    <meta name="author" content="Jadiel Sousa, OnTop Sistemas">
    <meta name="generator" content="VSCode">
    <title>WContagem - OnTop Sistemas</title>
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/produtos.css" rel="stylesheet">
    <link href="assets/icons/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body class="bg-success bg-gradient">
    <nav class="navbar navbar-expand-md navbar-light bg-light fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php"><i class="bi bi-house"></i>  WContagem - <?= $_SESSION['nome'] ?></a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav me-auto mb-2 mb-md-0">
                    <a class="nav-item nav-link " href="produtos.php">Produtos</a>
                    <a class="nav-item nav-link disabled" href="alteracao.php">Alteração</a>
                    <a class="nav-item nav-link active" href="historico.php">Histórico</a>
                    <a class="nav-item nav-link " href="logout.php">Sair</a>
                </div>
            </div>
        </div>
    </nav>

    <main class="w-100 form ">
        <div class="mb-3"></div>
        <?php
            $query = "SELECT ea.arcodigo, e.ardesnot, e.arrefere, e.arcodbar, m.arnommar, ea.data_movi, 
            ea.saldo_anterior, ea.saldo_atual FROM estoque_ajuste ea 
            LEFT JOIN estoque e ON e.arcodigo = ea.arcodigo
            LEFT JOIN vendedor v ON v.arcodvde = ea.usuario
            LEFT JOIN marcas m ON m.arcodmar = e.arcodmar
            ORDER BY data_movi DESC
            LIMIT 100";
            $res = mysqli_query($conn, $query);
            if (mysqli_num_rows($res) > 0) {
                $num = true;
                while ($row = $res->fetch_object()) {
                    $num = !$num;
                ?>
                    <div class="container ">
                        <div class="card card-mid <?php if ($num) echo "bg-success-subtle"; ?>">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="fs-6 fw-bold border-bottom <?php if ($num) echo "border-white"; ?>"><?php echo $row->ardesnot; ?></div>
                                    </div>                                    
                                </div>
                                <!-- </div> -->
                                <div class="row">
                                    <div class="col-2">
                                        <label for="arcodigo" class="small">CÓDIGO</label>
                                        <div class="fs-6 border-bottom  <?php if ($num) echo "border-white"; ?>"><?php if ($row->arcodigo == "") {
                                                                                                                        echo "-";
                                                                                                                    } else {
                                                                                                                        echo $row->arcodigo;
                                                                                                                    } ?></div>
                                    </div>
                                    <div class="col-10">
                                        <label for="arrefere" class="small">MARCA</label>
                                        <div class="fs-6 border-bottom  <?php if ($num) echo "border-white"; ?>"><?php if ($row->arnommar == "") {
                                                                                                                        echo "-";
                                                                                                                    } else {
                                                                                                                        echo $row->arnommar;
                                                                                                                    } ?></div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <label for="arcodigo" class="small">REFERÊNCIA</label>
                                        <div class="fs-6 border-bottom  <?php if ($num) echo "border-white"; ?>"><?php if ($row->arrefere == "") {
                                                                                                                        echo "-";
                                                                                                                    } else {
                                                                                                                        echo $row->arrefere;
                                                                                                                    } ?></div>
                                    </div>
                                    <div class="col-6">
                                        <label for="arrefere" class="small">CÓD. BARRAS</label>
                                        <div class="fs-6 border-bottom  <?php if ($num) echo "border-white"; ?>"><?php if ($row->arcodbar == "") {
                                                                                                                        echo "-";
                                                                                                                    } else {
                                                                                                                        echo $row->arcodbar;
                                                                                                                    } ?></div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <label for="arcodigo" class="small">QTD. ANTERIOR</label>
                                        <div class="fs-6 border-bottom  <?php if ($num) echo "border-white"; ?>"><?php if ($row->saldo_anterior == "") {
                                                                                                                        echo "-";
                                                                                                                    } else {
                                                                                                                        echo $row->saldo_anterior;
                                                                                                                    } ?></div>
                                    </div>
                                    <div class="col-6">
                                        <label for="arrefere" class="small">QTD ATUAL</label>
                                        <div class="fs-6 border-bottom  <?php if ($num) echo "border-white"; ?>"><?php if ($row->saldo_atual == "") {
                                                                                                                        echo "-";
                                                                                                                    } else {
                                                                                                                        echo $row->saldo_atual;
                                                                                                                    } ?></div>
                                    </div>                                    
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
        <?php } else {
                echo mysqli_error($conn);
            } ?>
        <div class="container">
            <footer class="fixed-botton pt-3">
                <div class="row">
                    <div class="d-flex justify-content-between border-top text-white">
            <p><i class="bi-pci-card"></i>        <?php echo $_SESSION['mac']; ?></p><p>&copy; <script>document.write(new Date().getFullYear())</script> <a class="link-light" href="https://ontopsistemas.com.br">OnTop Sistemas</a>.</p>
            <?php echo $_SESSION['dberror']; ?>
                                </div>
                </div>
                
            </footer>
    </div>
    </main>    
    <script src="assets/js/bootstrap.min.js"></script>
</body>

</html>