<?php
    session_start();
    include "db_connect.php";
    if (isset($_POST["termo"])) {
        $_SESSION["termo"] = $_POST["termo"];
    }
?>
<!DOCTYPE html>
<html lang="pt-BR" data-bs-theme="auto">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="Controle de estoque">
        <meta name="author" content="Jadiel Sousa, OnTop Sistemas">
        <meta name="generator" content="VSCode">    
        <title>WContagem - OnTop Sistemas</title>
        <link href="assets/css/bootstrap.min.css" rel="stylesheet">
        <link href="assets/css/style.css" rel="stylesheet">
    </head>
    <body class="bg-success bg-gradient">
        <main class="w-100 m-auto">
            <div class="card">
                <div class="card-header">PESQUISA DE PRODUTOS</div>
                <div class="card-body">
                    <form class="row g-4" action="produtos.php" method="post">
                            <div class="col-10"> 
                                <!--<label for="termo" class="form-label">Pesquisar por...</label>-->
                                <input type="text" class="form-control" id="termo" name="termo" aria-describedby="termoHelp" placeholder="Pesquisar por..." required>
                                <div id="termoHelp" class="form-text">Você pode digitar o nome, referência ou código de barras.</div>
                            </div>
                            <div class="col-2">
                                <button type="submit" class="btn btn-primary">Pesquisar</button>
                            </div>
                    </form>
                </div>
            </div>
            <?php if (isset($_SESSION['termo'])) {
                echo "passou 001";
                $termo = $_SESSION['termo'];
                $query = "SELECT arcodigo, ardesnot, arrefere, arcodbar, sr_recno FROM estoque WHERE (arcodigo = '$termo') OR (arrefere = '$termo') OR (arcodbar LIKE '$termo%') LIMIT 50";
                $res = mysqli_query($conn, $query);
                if (mysqli_num_rows($res) > 0) { ?>
                    <div class="card">
                        <div class="card-body">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">Código</th>
                                        <th scope="col">Descrição</th>
                                        <th scope="col">Referência</th>
                                        <th scope="col">ID</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($row = $res->fetch_object()) { ?>
                                        <tr>
                                        <th scope="row"><?php echo $row->sr_recno; ?></th>
                                        <td><?php echo $row->arcodigo; ?></td>
                                        <td><?php echo $row->ardesnot; ?></td>
                                        <td><?php echo $row->arrefere; ?></td> 
                                        </tr>           
                                    <?php } ?>
                                </tbody>   
                            </table>
                        </div>
                    </div>
                <?php }
            } else {
                echo "Sessão não encontrada";
            } ?>
        </main>
        <footer class="position-absolute top-100 start-50 translate-middle text-white">
            <p>&copy; <script>document.write(new Date().getFullYear())</script> OnTop Sistemas.</p>
        </footer>
    </body>
</html>